/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.blocks.crackable;

import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.ordana.immersive_weathering.IWPlatformStuff;
import com.ordana.immersive_weathering.blocks.PatchSpreader;
import com.ordana.immersive_weathering.blocks.Weatherable;
import com.ordana.immersive_weathering.blocks.crackable.CrackSpreader;
import com.ordana.immersive_weathering.configs.CommonConfigs;
import com.ordana.immersive_weathering.reg.ModBlocks;
import com.ordana.immersive_weathering.util.WeatheringHelper;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_5819;

public interface Crackable
extends Weatherable {
    public static final Supplier<BiMap<class_2248, class_2248>> CRACK_LEVEL_INCREASES = Suppliers.memoize(() -> {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder().put((Object)class_2246.field_10056, (Object)class_2246.field_10416).put((Object)class_2246.field_10104, (Object)ModBlocks.CRACKED_BRICKS.get()).put((Object)class_2246.field_23874, (Object)class_2246.field_23875).put((Object)class_2246.field_10266, (Object)class_2246.field_23867).put((Object)class_2246.field_28900, (Object)class_2246.field_29222).put((Object)class_2246.field_28896, (Object)class_2246.field_29223).put((Object)class_2246.field_10006, (Object)ModBlocks.CRACKED_PRISMARINE_BRICKS.get()).put((Object)class_2246.field_10462, (Object)ModBlocks.CRACKED_END_STONE_BRICKS.get()).put((Object)class_2246.field_10131, (Object)ModBlocks.CRACKED_STONE_BRICK_SLAB.get()).put((Object)class_2246.field_10191, (Object)ModBlocks.CRACKED_BRICK_SLAB.get()).put((Object)class_2246.field_23877, (Object)ModBlocks.CRACKED_POLISHED_BLACKSTONE_BRICK_SLAB.get()).put((Object)class_2246.field_10390, (Object)ModBlocks.CRACKED_NETHER_BRICK_SLAB.get()).put((Object)class_2246.field_28902, (Object)ModBlocks.CRACKED_DEEPSLATE_BRICK_SLAB.get()).put((Object)class_2246.field_28898, (Object)ModBlocks.CRACKED_DEEPSLATE_TILE_SLAB.get()).put((Object)class_2246.field_10236, (Object)ModBlocks.CRACKED_PRISMARINE_BRICK_SLAB.get()).put((Object)class_2246.field_10064, (Object)ModBlocks.CRACKED_END_STONE_BRICK_SLAB.get()).put((Object)class_2246.field_10392, (Object)ModBlocks.CRACKED_STONE_BRICK_STAIRS.get()).put((Object)class_2246.field_10089, (Object)ModBlocks.CRACKED_BRICK_STAIRS.get()).put((Object)class_2246.field_23878, (Object)ModBlocks.CRACKED_POLISHED_BLACKSTONE_BRICK_STAIRS.get()).put((Object)class_2246.field_10159, (Object)ModBlocks.CRACKED_NETHER_BRICK_STAIRS.get()).put((Object)class_2246.field_28901, (Object)ModBlocks.CRACKED_DEEPSLATE_BRICK_STAIRS.get()).put((Object)class_2246.field_28897, (Object)ModBlocks.CRACKED_DEEPSLATE_TILE_STAIRS.get()).put((Object)class_2246.field_10190, (Object)ModBlocks.CRACKED_PRISMARINE_BRICK_STAIRS.get()).put((Object)class_2246.field_10012, (Object)ModBlocks.CRACKED_END_STONE_BRICK_STAIRS.get()).put((Object)class_2246.field_10252, (Object)ModBlocks.CRACKED_STONE_BRICK_WALL.get()).put((Object)class_2246.field_10269, (Object)ModBlocks.CRACKED_BRICK_WALL.get()).put((Object)class_2246.field_23879, (Object)ModBlocks.CRACKED_POLISHED_BLACKSTONE_BRICK_WALL.get()).put((Object)class_2246.field_10127, (Object)ModBlocks.CRACKED_NETHER_BRICK_WALL.get()).put((Object)class_2246.field_28903, (Object)ModBlocks.CRACKED_DEEPSLATE_BRICK_WALL.get()).put((Object)class_2246.field_28899, (Object)ModBlocks.CRACKED_DEEPSLATE_TILE_WALL.get()).put((Object)ModBlocks.PRISMARINE_BRICK_WALL.get(), (Object)ModBlocks.CRACKED_PRISMARINE_BRICK_WALL.get()).put((Object)class_2246.field_10001, (Object)ModBlocks.CRACKED_END_STONE_BRICK_WALL.get());
        WeatheringHelper.addOptional((ImmutableBiMap.Builder<class_2248, class_2248>)builder, "quark:vertical_brick_slab", "immersive_weathering:vertical_cracked_brick_slab");
        WeatheringHelper.addOptional((ImmutableBiMap.Builder<class_2248, class_2248>)builder, "quark:vertical_stone_brick_slab", "immersive_weathering:vertical_cracked_stone_brick_slab");
        WeatheringHelper.addOptional((ImmutableBiMap.Builder<class_2248, class_2248>)builder, "quark:vertical_polished_blackstone_brick_slab", "immersive_weathering:vertical_cracked_polished_blackstone_brick_slab");
        WeatheringHelper.addOptional((ImmutableBiMap.Builder<class_2248, class_2248>)builder, "quark:vertical_nether_brick_slab", "immersive_weathering:vertical_cracked_nether_brick_slab");
        WeatheringHelper.addOptional((ImmutableBiMap.Builder<class_2248, class_2248>)builder, "quark:vertical_deepslate_brick_slab", "immersive_weathering:vertical_cracked_deepslate_brick_slab");
        WeatheringHelper.addOptional((ImmutableBiMap.Builder<class_2248, class_2248>)builder, "quark:vertical_deepslate_tile_slab", "immersive_weathering:vertical_cracked_deepslate_tile_slab");
        WeatheringHelper.addOptional((ImmutableBiMap.Builder<class_2248, class_2248>)builder, "quark:vertical_end_stone_brick_slab", "immersive_weathering:vertical_cracked_end_stone_brick_slab");
        WeatheringHelper.addOptional((ImmutableBiMap.Builder<class_2248, class_2248>)builder, "quark:vertical_prismarine_brick_slab", "immersive_weathering:vertical_cracked_prismarine_brick_slab");
        IWPlatformStuff.addExtraCrackedBlocks((ImmutableBiMap.Builder<class_2248, class_2248>)builder);
        return builder.build();
    });
    public static final Supplier<BiMap<class_2248, class_2248>> CRACK_LEVEL_DECREASES = Suppliers.memoize(() -> CRACK_LEVEL_INCREASES.get().inverse());

    public static class_2680 getUncrackedCrackBlock(class_2680 state) {
        class_2248 block2 = state.method_26204();
        class_2248 block3 = (class_2248)CRACK_LEVEL_DECREASES.get().get((Object)block2);
        while (block3 != null) {
            block2 = block3;
            block3 = (class_2248)CRACK_LEVEL_DECREASES.get().get((Object)block2);
        }
        return block2.method_34725(state);
    }

    public static class_2680 getCrackedBlock(class_2680 state) {
        class_2248 block2 = state.method_26204();
        class_2248 block3 = (class_2248)CRACK_LEVEL_INCREASES.get().get((Object)block2);
        while (block3 != null) {
            block2 = block3;
            block3 = (class_2248)CRACK_LEVEL_INCREASES.get().get((Object)block2);
        }
        return block2.method_34725(state);
    }

    public static Optional<class_2248> getDecreasedCrackBlock(class_2248 block) {
        return Optional.ofNullable((class_2248)CRACK_LEVEL_DECREASES.get().get((Object)block));
    }

    public static Optional<class_2248> getIncreasedCrackBlock(class_2248 block) {
        return Optional.ofNullable((class_2248)CRACK_LEVEL_INCREASES.get().get((Object)block));
    }

    default public Optional<class_2680> getNextCracked(class_2680 state) {
        return Crackable.getIncreasedCrackBlock(state.method_26204()).map(block -> block.method_34725(state));
    }

    default public Optional<class_2680> getPreviousCracked(class_2680 state) {
        return Crackable.getDecreasedCrackBlock(state.method_26204()).map(block -> block.method_34725(state));
    }

    public CrackSpreader getCrackSpreader();

    @Override
    default public <T extends Enum<?>> Optional<PatchSpreader<T>> getPatchSpreader(Class<T> weatheringClass) {
        if (weatheringClass == CrackLevel.class) {
            return Optional.of(this.getCrackSpreader());
        }
        return Optional.empty();
    }

    public CrackLevel getCrackLevel();

    @Override
    default public boolean shouldWeather(class_2680 state, class_2338 pos, class_1937 level) {
        if (!CommonConfigs.CRACK_SPREADING_ENABLED.get().booleanValue()) {
            return false;
        }
        return this.getCrackSpreader().getWantedWeatheringState(false, pos, level);
    }

    public class_1792 getRepairItem(class_2680 var1);

    @Override
    default public void tryWeather(class_2680 state, class_3218 serverLevel, class_2338 pos, class_5819 random) {
        if (random.method_43057() < this.getWeatherChanceSpeed()) {
            class_2680 newState;
            Optional<class_2680> opt = Optional.empty();
            if (this.getCrackSpreader().getWantedWeatheringState(true, pos, (class_1937)serverLevel)) {
                opt = this.getNextCracked(state);
            }
            if ((newState = opt.orElse((class_2680)state.method_11657(Weatherable.WEATHERABLE, (Comparable)((Object)Weatherable.WeatheringState.FALSE)))) != state) {
                serverLevel.method_8652(pos, newState, 2);
                if (!newState.method_28498(Weatherable.WEATHERABLE)) {
                    serverLevel.method_39279(pos, state.method_26204(), 1);
                }
            }
        }
    }

    public static enum CrackLevel {
        UNCRACKED,
        CRACKED;

    }
}

